%{
Copyright (c) 2011, MIT.
Developed with the sponsorship of the Defense Advanced Research Projects
Agency (DARPA).

Permission is hereby granted, free of charge, to any person obtaining a copy
of this data, including any software or models in source or binary form, as
well as any drawings, specifications, and documentation (collectively "the
Data"), to deal in the Data without restriction, including without
limitation the rights to use, copy, modify, merge, publish, distribute,
sublicense, and/or sell copies of the Data, and to permit persons to whom
the Data is furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Data.

THE DATA IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS, SPONSORS, DEVELOPERS, CONTRIBUTORS, OR COPYRIGHT HOLDERS BE LIABLE
FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT,
TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE DATA OR
THE USE OR OTHER DEALINGS IN THE DATA.
%}

% Matt Fitzgerald
% Space Tug data loader
clear all

A = importdata('tradespaceData.csv',',');
designVariables = cell(128,3);
designVariables(:,1:2) = A.textdata;
designVariables(:,3) = num2cell(A.data(:,1));

disp('Attribute and Cost calculation: present DFC0')
[costPres0 attPres0 interP0] = designCalculator(designVariables,0,'present');
disp('Attribute and Cost calculation: present DFC1')
[costPres1 attPres1 interP1] = designCalculator(designVariables,1,'present');
disp('Attribute and Cost calculation: present DFC2')
[costPres2 attPres2 interP2] = designCalculator(designVariables,2,'present');
disp('Attribute and Cost calculation: future DFC0')
[costFut0 attFut0 interF0] = designCalculator(designVariables,0,'future');
disp('Attribute and Cost calculation: future DFC1')
[costFut1 attFut1 interF1] = designCalculator(designVariables,1,'future');
disp('Attribute and Cost calculation: future DFC2')
[costFut2 attFut2 interF2] = designCalculator(designVariables,2,'future');

% set (design,epoch) cost matrix
costPres = [costPres0;costPres1;costPres2];
costFut = [costFut0;costFut1;costFut2];
COSTS = [repmat(costPres,1,8) repmat(costFut,1,8)];

% combine inter vectors
interPres = [interP0;interP1;interP2];
interFut = [interF0;interF1;interF2];

% calculate utilities
attPres = [attPres0;attPres1;attPres2];
attFut = [attFut0;attFut1;attFut2];
load spaceTugPrefSets.mat % puts "allPrefs" and "allWeights" in workspace
MAU = zeros(size(attPres,1),size(allPrefs,1)*2);
for e = 1:size(allPrefs,1)
    disp(['Utility Calculations for pref set: ' num2str(e)])
    [MAUpres SAUpres] = SpaceTugMAUcalc(attPres,allPrefs(e,:),allWeights(e,:));
    [MAUfut SAUfut] = SpaceTugMAUcalc(attFut,allPrefs(e,:),allWeights(e,:));
    
    MAU(:,e) = MAUpres;
    MAU(:,e+8) = MAUfut;
end

% calulate fuzzy pareto values
fuzzyParetoNumbers = calcFuzzyParetoNumbers(MAU,COSTS);

% create transition matrices
%{
disp('Generating Transition Matrices')
[TcostPRESENT TtimePRESENT TcostFUTURE TtimeFUTURE] = SpaceTugTransMatrixGenerator(COSTS);
% collapse rules 1-5 (redesign rules)
[RulePathsPRESENT DesignPathsPRESENT CostPathsPRESENT] = ruleCollapse2(TcostPRESENT(1:5),TtimePRESENT(1:5),1,3,0,0);
[RulePathsFUTURE DesignPathsFUTURE CostPathsFUTURE] = ruleCollapse2(TcostFUTURE(1:5),TtimeFUTURE(1:5),1,3,0,0);
% attach refuel rule
for i = 1:size(RulePathsPRESENT,1)
    for j = 1:size(RulePathsPRESENT,2)
        if TcostPRESENT{6}(i,j) ~= 0
            RulePathsPRESENT{i,j} = [RulePathsPRESENT{i,j};6];
            RulePathsFUTURE{i,j} = [RulePathsFUTURE{i,j};6];
            DesignPathsPRESENT{i,j} = [DesignPathsPRESENT{i,j};[i j]];
            DesignPathsFUTURE{i,j} = [DesignPathsFUTURE{i,j};[i j]];
            CostPathsPRESENT{i,j} = [CostPathsPRESENT{i,j};[TcostPRESENT{6}(i,j) TtimePRESENT{6}(i,j)]];
            CostPathsFUTURE{i,j} = [CostPathsFUTURE{i,j};[TcostFUTURE{6}(i,j) TtimeFUTURE{6}(i,j)]];
        end
    end
end
%}
% save time by loading saved transitions
 load spaceTugCollapsedTransitions.mat

clearvars -except MAU COSTS attPres attFut RulePathsPRESENT DesignPathsPRESENT CostPathsPRESENT RulePathsFUTURE DesignPathsFUTURE CostPathsFUTURE fuzzyParetoNumbers
